Ext.data.JsonP.sol_contact_Utils({"tagname":"class","name":"sol.contact.Utils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.contact.Utils.js","href":"lib_sol.contact.Utils.html#sol-contact-Utils"}],"author":[{"tagname":"author","name":"JHR, ELO Digital Office GmbH","email":null}],"version":["1.05.002"],"eloix":true,"eloas":true,"requires":["handlebars","sol.common.AclUtils","sol.common.Config","sol.common.IxUtils","sol.common.RepoUtils","sol.common.SordUtils","sol.common.StringUtils","sol.common.Template","sol.common.WfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"buildCompanyTempName","tagname":"method","owner":"sol.contact.Utils","id":"method-buildCompanyTempName","meta":{"private":true}},{"name":"buildContactTempName","tagname":"method","owner":"sol.contact.Utils","id":"method-buildContactTempName","meta":{"private":true}},{"name":"createCompany","tagname":"method","owner":"sol.contact.Utils","id":"method-createCompany","meta":{}},{"name":"createContact","tagname":"method","owner":"sol.contact.Utils","id":"method-createContact","meta":{}},{"name":"getCompanyReference","tagname":"method","owner":"sol.contact.Utils","id":"method-getCompanyReference","meta":{}},{"name":"getCompanyTemplateObjId","tagname":"method","owner":"sol.contact.Utils","id":"method-getCompanyTemplateObjId","meta":{"private":true}},{"name":"getConfigPart","tagname":"method","owner":"sol.contact.Utils","id":"method-getConfigPart","meta":{}},{"name":"getContactReference","tagname":"method","owner":"sol.contact.Utils","id":"method-getContactReference","meta":{}},{"name":"getContactTemplateObjId","tagname":"method","owner":"sol.contact.Utils","id":"method-getContactTemplateObjId","meta":{"private":true}},{"name":"getIdRegisterFolder","tagname":"method","owner":"sol.contact.Utils","id":"method-getIdRegisterFolder","meta":{}},{"name":"getParentCompany","tagname":"method","owner":"sol.contact.Utils","id":"method-getParentCompany","meta":{}},{"name":"getParentContact","tagname":"method","owner":"sol.contact.Utils","id":"method-getParentContact","meta":{}},{"name":"getParentContactList","tagname":"method","owner":"sol.contact.Utils","id":"method-getParentContactList","meta":{}},{"name":"getSolType","tagname":"method","owner":"sol.contact.Utils","id":"method-getSolType","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"isCompany","tagname":"method","owner":"sol.contact.Utils","id":"method-isCompany","meta":{}},{"name":"isContact","tagname":"method","owner":"sol.contact.Utils","id":"method-isContact","meta":{}},{"name":"isContactList","tagname":"method","owner":"sol.contact.Utils","id":"method-isContactList","meta":{}},{"name":"isContactManagementObject","tagname":"method","owner":"sol.contact.Utils","id":"method-isContactManagementObject","meta":{}},{"name":"loadConfig","tagname":"method","owner":"sol.contact.Utils","id":"method-loadConfig","meta":{}},{"name":"mapData","tagname":"method","owner":"sol.contact.Utils","id":"method-mapData","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.contact.Utils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.contact.Utils</strong></div></div><h4>Requires</h4><div class='dependency'>handlebars</div><div class='dependency'><a href='#!/api/sol.common.AclUtils' rel='sol.common.AclUtils' class='docClass'>sol.common.AclUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Config' rel='sol.common.Config' class='docClass'>sol.common.Config</a></div><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.StringUtils' rel='sol.common.StringUtils' class='docClass'>sol.common.StringUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils' target='_blank'>lib_sol.contact.Utils.js</a></div></pre><div class='doc-contents'><p>Contact management utilities</p>\n      <p class='version-tag'>Version: <b>1.05.002</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-buildCompanyTempName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-buildCompanyTempName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-buildCompanyTempName' class='name expandable'>buildCompanyTempName</a>( <span class='pre'>companyType, [fromService]</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates the new company (temporary) name. ...</div><div class='long'><p>Creates the new company (temporary) name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>companyType</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>fromService</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, a prefix will be set that the element / workflow can be recoqnised (uses <a href=\"#!/api/sol.common.WfUtils-method-createServiceWfName\" rel=\"sol.common.WfUtils-method-createServiceWfName\" class=\"docClass\">sol.common.WfUtils.createServiceWfName</a>)</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-buildContactTempName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-buildContactTempName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-buildContactTempName' class='name expandable'>buildContactTempName</a>( <span class='pre'>contactType, [fromService]</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Creates the new contact (temporary) name. ...</div><div class='long'><p>Creates the new contact (temporary) name.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contactType</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>fromService</span> : Boolean (optional)<div class='sub-desc'><p>If <code>true</code>, a prefix will be set that the element / workflow can be recoqnised (uses <a href=\"#!/api/sol.common.WfUtils-method-createServiceWfName\" rel=\"sol.common.WfUtils-method-createServiceWfName\" class=\"docClass\">sol.common.WfUtils.createServiceWfName</a>)</p>\n<p>Defaults to: <code>false</code></p></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-createCompany' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-createCompany' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-createCompany' class='name expandable'>createCompany</a>( <span class='pre'>companyType, [params]</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new company in the chaos cabinet. ...</div><div class='long'><p>Creates a new company in the chaos cabinet.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>companyType</span> : String<div class='sub-desc'><p>Used to determine the company template.</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>owner</span> : de.elo.ix.client.UserInfo (optional)<div class='sub-desc'><p>This user will be granted full access to the new company element</p>\n</div></li><li><span class='pre'>fromService</span> : Boolean (optional)<div class='sub-desc'><p>This will be reflected in the new elements name (used for further processing)</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Result contains <code>objId</code> of the new element and <code>name</code> of the new element</p>\n</div></li></ul></div></div></div><div id='method-createContact' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-createContact' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-createContact' class='name expandable'>createContact</a>( <span class='pre'>contactType, [params]</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Creates a new contact in the chaos cabinet. ...</div><div class='long'><p>Creates a new contact in the chaos cabinet.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contactType</span> : String<div class='sub-desc'><p>Used to determine the contact template.</p>\n</div></li><li><span class='pre'>params</span> : Object (optional)<div class='sub-desc'>\n<ul><li><span class='pre'>owner</span> : de.elo.ix.client.UserInfo (optional)<div class='sub-desc'><p>This user will be granted full access to the new contact element</p>\n</div></li><li><span class='pre'>fromService</span> : Boolean (optional)<div class='sub-desc'><p>This will be reflected in the new elements name (used for further processing)</p>\n<p>Defaults to: <code>false</code></p></div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Result contains <code>objId</code> of the new element and <code>name</code> of the new element</p>\n</div></li></ul></div></div></div><div id='method-getCompanyReference' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getCompanyReference' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getCompanyReference' class='name expandable'>getCompanyReference</a>( <span class='pre'>sord</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the company reference. ...</div><div class='long'><p>Retrieves the company reference.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>This can either be a objId or a Sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The company reference or <code>null</code> if no reference was found</p>\n</div></li></ul></div></div></div><div id='method-getCompanyTemplateObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getCompanyTemplateObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getCompanyTemplateObjId' class='name expandable'>getCompanyTemplateObjId</a>( <span class='pre'>companyType</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the path of the company template. ...</div><div class='long'><p>Retrieves the path of the company template.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>companyType</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getConfigPart' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getConfigPart' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getConfigPart' class='name expandable'>getConfigPart</a>( <span class='pre'>config, sord</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Get config part ...</div><div class='long'><p>Get config part</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>Configuration</p>\n</div></li><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Configuration part</p>\n</div></li></ul></div></div></div><div id='method-getContactReference' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getContactReference' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getContactReference' class='name expandable'>getContactReference</a>( <span class='pre'>sord</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Retrieves the contact reference. ...</div><div class='long'><p>Retrieves the contact reference.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>This can either be a objId or a Sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The contact reference or <code>null</code> if no reference was found</p>\n</div></li></ul></div></div></div><div id='method-getContactTemplateObjId' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getContactTemplateObjId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getContactTemplateObjId' class='name expandable'>getContactTemplateObjId</a>( <span class='pre'>contactType</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the path of the contact template. ...</div><div class='long'><p>Retrieves the path of the contact template.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>contactType</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getIdRegisterFolder' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getIdRegisterFolder' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getIdRegisterFolder' class='name expandable'>getIdRegisterFolder</a>( <span class='pre'>objId, regPrefix</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Searches the registerfolder for a prefix. ...</div><div class='long'><p>Searches the registerfolder for a prefix.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>regPrefix</span> : String<div class='sub-desc'><p>, e.g. 'A'</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>objId of registerfolder</p>\n</div></li></ul></div></div></div><div id='method-getParentCompany' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getParentCompany' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getParentCompany' class='name expandable'>getParentCompany</a>( <span class='pre'>objId</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Searches the repository hierarchy to find the parent company (if there is any). ...</div><div class='long'><p>Searches the repository hierarchy to find the parent company (if there is any).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getParentContact' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getParentContact' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getParentContact' class='name expandable'>getParentContact</a>( <span class='pre'>objId</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Searches the repository hierarchy to find the parent contact (if there is any). ...</div><div class='long'><p>Searches the repository hierarchy to find the parent contact (if there is any).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getParentContactList' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getParentContactList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getParentContactList' class='name expandable'>getParentContactList</a>( <span class='pre'>objId</span> ) : de.elo.ix.client.Sord<span class=\"signature\"></span></div><div class='description'><div class='short'>Searches the repository hierarchy to find the parent contactlist (if there is any). ...</div><div class='long'><p>Searches the repository hierarchy to find the parent contactlist (if there is any).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>objId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>de.elo.ix.client.Sord</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getSolType' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-getSolType' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-getSolType' class='name expandable'>getSolType</a>( <span class='pre'>sord</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-isCompany' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-isCompany' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-isCompany' class='name expandable'>isCompany</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an element is from type company ...</div><div class='long'><p>Checks, if an element is from type company</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>This can either be a objId or a Sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isContact' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-isContact' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-isContact' class='name expandable'>isContact</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an element is from type contact ...</div><div class='long'><p>Checks, if an element is from type contact</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>This can either be a objId or a Sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isContactList' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-isContactList' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-isContactList' class='name expandable'>isContactList</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an element is from type contactlist ...</div><div class='long'><p>Checks, if an element is from type contactlist</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>This can either be a objId or a Sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-isContactManagementObject' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-isContactManagementObject' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-isContactManagementObject' class='name expandable'>isContactManagementObject</a>( <span class='pre'>sord</span> ) : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>Checks, if an element is from type of contact management object ...</div><div class='long'><p>Checks, if an element is from type of contact management object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : String|de.elo.ix.client.Sord<div class='sub-desc'><p>This can either be a objId or a Sord object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Boolean</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-loadConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-loadConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-loadConfig' class='name expandable'>loadConfig</a>( <span class='pre'></span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>Loads (and merges) the contact configuration from the JSON file: /Administration/Business Solutions/contact/Configura...</div><div class='long'><p>Loads (and merges) the contact configuration from the JSON file: <code>/Administration/Business Solutions/contact/Configuration/contact.config</code></p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-mapData' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.contact.Utils'>sol.contact.Utils</span><br/><a href='source/lib_sol.contact.Utils.html#sol-contact-Utils-method-mapData' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.contact.Utils-method-mapData' class='name expandable'>mapData</a>( <span class='pre'>templateSord</span> ) : Object[]<span class=\"signature\"></span></div><div class='description'><div class='short'>Maps the data from the batch importer so it can be used by the existing createX RFs. ...</div><div class='long'><p>Maps the data from the batch importer so it can be used by the existing createX RFs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templateSord</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object[]</span><div class='sub-desc'><p>An input object array for the <a href=\"#!/api/sol.common.SordUtils-method-updateSord\" rel=\"sol.common.SordUtils-method-updateSord\" class=\"docClass\">updateSord</a> method.</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"singleton":true}});